/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LineBuffer
implements Iterable<String> {
    private ArrayList<String> lines = new ArrayList();

    public int size() {
        return this.lines.size();
    }

    public String get(int index) {
        String line = this.lines.get(index);
        return line;
    }

    public void add(String line) {
        this.checkLine(line);
        this.lines.add(line);
    }

    public void add(String[] ls) {
        for (int i = 0; i < ls.length; ++i) {
            String line = ls[i];
            this.add(line);
        }
    }

    public void insert(int index, String line) {
        this.checkLine(line);
        this.lines.add(index, line);
    }

    public void insert(int index, String[] ls) {
        for (int i = 0; i < ls.length; ++i) {
            String line = ls[i];
            this.checkLine(line);
        }
        this.lines.addAll(index, Arrays.asList(ls));
    }

    private void checkLine(String line) {
        if (line == null) {
            throw new IllegalArgumentException("Line is null");
        }
        if (line.indexOf(10) >= 0) {
            throw new IllegalArgumentException("Line contains LF");
        }
        if (line.indexOf(13) >= 0) {
            throw new IllegalArgumentException("Line contains CR");
        }
    }

    public int indexMatch(Pattern regexp) {
        for (int i = 0; i < this.lines.size(); ++i) {
            String line = this.lines.get(i);
            Matcher matcher = regexp.matcher(line);
            if (!matcher.matches()) continue;
            return i;
        }
        return -1;
    }

    public static LineBuffer readAll(Reader reader) throws IOException {
        String line;
        LineBuffer lb = new LineBuffer();
        BufferedReader br = new BufferedReader(reader);
        while ((line = br.readLine()) != null) {
            lb.add(line);
        }
        br.close();
        return lb;
    }

    public String[] getLines() {
        String[] ls = this.lines.toArray(new String[this.lines.size()]);
        return ls;
    }

    @Override
    public Iterator<String> iterator() {
        return new Itr();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.lines.size(); ++i) {
            String line = this.lines.get(i);
            sb.append(line);
            sb.append("\n");
        }
        return sb.toString();
    }

    public class Itr
    implements Iterator<String> {
        private int position;

        @Override
        public boolean hasNext() {
            return this.position < LineBuffer.this.lines.size();
        }

        @Override
        public String next() {
            String line = (String)LineBuffer.this.lines.get(this.position);
            ++this.position;
            return line;
        }
    }
}

