/*
 * Decompiled with CFR 0.152.
 */
package i18nupdatemod.util;

import i18nupdatemod.util.Log;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class FileUtil {
    private static Path resourcePackDirPath;
    private static Path temporaryDirPath;

    public static void setResourcePackDirPath(Path path) {
        FileUtil.safeCreateDir(path);
        resourcePackDirPath = path;
    }

    public static void setTemporaryDirPath(Path temporaryDirPath) {
        FileUtil.safeCreateDir(temporaryDirPath);
        FileUtil.temporaryDirPath = temporaryDirPath;
    }

    private static void safeCreateDir(Path path) {
        try {
            if (!Files.isDirectory(path, new LinkOption[0])) {
                Files.createDirectories(path, new FileAttribute[0]);
            }
        }
        catch (Exception e) {
            Log.warning("Cannot create dir: " + e);
        }
    }

    public static Path getResourcePackPath(String filename) {
        return resourcePackDirPath.resolve(filename);
    }

    public static Path getTemporaryPath(String filename) {
        return temporaryDirPath.resolve(filename);
    }

    public static void syncTmpFile(Path filePath, Path tmpFilePath, boolean saveToGame) throws IOException {
        Path to;
        Path from;
        if (!Files.exists(filePath, new LinkOption[0]) && !Files.exists(tmpFilePath, new LinkOption[0])) {
            Log.debug("Both temp and current file not found");
            return;
        }
        int cmp = FileUtil.compareTmpFile(filePath, tmpFilePath);
        if (cmp == 0) {
            Log.debug("Temp and current file has already been synchronized");
            return;
        }
        if (cmp < 0) {
            from = filePath;
            to = tmpFilePath;
        } else {
            from = tmpFilePath;
            to = filePath;
        }
        if (!saveToGame && to == filePath) {
            return;
        }
        Files.copy(from, to, StandardCopyOption.REPLACE_EXISTING);
        Files.setLastModifiedTime(to, Files.getLastModifiedTime(from, new LinkOption[0]));
        Log.info(String.format("Synchronized: %s -> %s", from, to));
    }

    private static int compareTmpFile(Path filePath, Path tmpFilePath) throws IOException {
        if (!Files.exists(filePath, new LinkOption[0])) {
            return 1;
        }
        if (!Files.exists(tmpFilePath, new LinkOption[0])) {
            return -1;
        }
        return Files.getLastModifiedTime(tmpFilePath, new LinkOption[0]).compareTo(Files.getLastModifiedTime(filePath, new LinkOption[0]));
    }
}

