/*
 * Decompiled with CFR 0.152.
 */
package i18nupdatemod.fabricloader;

import i18nupdatemod.I18nUpdateMod;
import i18nupdatemod.util.Log;
import i18nupdatemod.util.Reflection;
import java.nio.file.Path;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;

public class FabricLoaderMod
implements ClientModInitializer {
    public void onInitializeClient() {
        Path gameDir = FabricLoader.getInstance().getGameDir();
        Log.setMinecraftLogFile(gameDir);
        String mcVersion = this.getMcVersion();
        if (mcVersion == null) {
            Log.warning("Minecraft version not found");
            return;
        }
        I18nUpdateMod.init(gameDir, mcVersion, "Fabric");
    }

    private String getMcVersion() {
        try {
            return (String)Reflection.clazz("net.fabricmc.loader.impl.FabricLoaderImpl").get("INSTANCE").get("getGameProvider()").get("getNormalizedGameVersion()").get();
        }
        catch (Exception exception) {
            try {
                return (String)Reflection.clazz("org.quiltmc.loader.impl.QuiltLoaderImpl").get("INSTANCE").get("getGameProvider()").get("getNormalizedGameVersion()").get();
            }
            catch (Exception exception2) {
                return null;
            }
        }
    }
}

